/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.ucode;

import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.launch.ucode.UcodeSurveyException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class UcodeSurveyProperties {
    private static Properties props;
    private static boolean loadedAsResource;
    private static String propertyFilename;
    private static String UCODE_PROPS_HOME;
    private static final String TRACE_MASKD = "JUCODESD";
    private static final String TRACE_MASKF = "JUCODESF";
    private static final String TRACE_MASKT = "JUCODEST";

    private UcodeSurveyProperties() {
    }

    private static void analyzeProps() {
        Properties properties = System.getProperties();
        System.setProperties(properties);
    }

    public static String getProperty(String string) {
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public static String getUcodePropHeader() {
        String string = "# Microcode Download properties file: \n#     weburl = address of url of Service website\n#     weburluser = userid of url of Service website\n#     weburlpw = password of url of Service website\n#     licenseaccept = has license for microcode been accepted\n";
        return string;
    }

    public static Properties initialize(String string, Properties properties) throws UcodeSurveyException {
        block7: {
            Trace.trace(TRACE_MASKT, "->UcodeSurveyProperties.initialize()");
            props = new Properties(properties);
            FileInputStream fileInputStream = null;
            try {
                propertyFilename = UCODE_PROPS_HOME + string + ".properties";
                fileInputStream = new FileInputStream(propertyFilename);
            }
            catch (IOException iOException) {
                Trace.trace(TRACE_MASKT, "->UcodeSurveyProperties.initialize() file not found " + propertyFilename);
                Trace.trace(TRACE_MASKT, "->UcodeSurveyProperties.initialize()");
                throw new UcodeSurveyException("Error initializing Properties file " + iOException.toString());
            }
            if (fileInputStream != null) {
                try {
                    props.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {
                    if (fileInputStream == null) break block7;
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException2) {
                        Trace.trace(TRACE_MASKT, "->UcodeSurveyProperties.initialize()");
                        throw new UcodeSurveyException("Error initializing Properties file " + iOException.toString());
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "->UcodeSurveyProperties.initialize()");
        return props;
    }

    public static void save(Properties properties) throws UcodeSurveyException {
        String string = UcodeSurveyProperties.getUcodePropHeader();
        Trace.trace(TRACE_MASKT, "->UcodeSurveyProperties.save()");
        if (properties.isEmpty()) {
            Trace.trace(TRACE_MASKF, "UcodeSurveyProperties.save() file is null");
            Trace.trace(TRACE_MASKT, "->UcodeSurveyProperties.save()");
            throw new UcodeSurveyException("Properties file is null");
        }
        try {
            File file = new File(new File(propertyFilename).getParent());
            if (!file.isDirectory() && !file.mkdir()) {
                Trace.trace(TRACE_MASKT, "Error creating directory \"" + file.getPath() + "\"");
                throw new UcodeSurveyException("Error creating directory \"" + file.getPath() + "\"");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(propertyFilename);
            properties.store(fileOutputStream, string);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Trace.trace(TRACE_MASKF, "Error writing properties file");
            throw new UcodeSurveyException("Error Error writing properties file " + iOException.toString());
        }
        Trace.trace(TRACE_MASKT, "<-UcodeSurveyProperties.save()");
    }

    public static void setProperties(Properties properties) throws UcodeSurveyException {
        if (properties == null) {
            throw new UcodeSurveyException("May not set global properties to null");
        }
        props = properties;
    }

    public static void setProperty(String string, String string2) {
        props.setProperty(string, string2);
    }

    static {
        loadedAsResource = false;
        UCODE_PROPS_HOME = "/var/adm/invscout/";
    }
}

